//=============================================================================
// PhotonBlast.
//=============================================================================
class PhotonBlast extends DeusExProjectile
	abstract;

var name damageType;
var ParticleGenerator smokeGen;

function PostBeginPlay()
{
	Super.PostBeginPlay();

   if (Level.NetMode == NM_DedicatedServer)
      return;
   
   SpawnPhotonEffects();
}

simulated function PostNetBeginPlay()
{
   Super.PostNetBeginPlay();
   
   if (Role != ROLE_Authority)
      SpawnPhotonEffects();
}

simulated function SpawnPhotonEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
      smokeGen.RemoteRole = ROLE_None;
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();

	Super.Destroyed();
}

defaultproperties
{
     DamageType=Photon
     bIgnoresNanoDefense=True
     ItemName="Photon Blast"
     ItemArticle="a"
     speed=4500.000000
     MaxSpeed=4500.000000
     Mesh=LodMesh'DeusExItems.FireComet'
     Fatness=157
     LightType=LT_Steady
     LightBrightness=25
     LightRadius=32
}
